﻿using System;
using System.Globalization;
using System.Windows.Data;
using PPDFrameworkCore;

namespace PPDExpansion.Converter
{
    class ScoreConverter : IMultiValueConverter
    {
        #region IMultiValueConverter メンバー

        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            string scoreName = values[0] as string;
            if (String.IsNullOrEmpty(scoreName))
            {
                return "";
            }
            Difficulty difficulty = (Difficulty)values[1];
            return string.Format("{0} {1}", scoreName, difficulty);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
